public static class ConsolePlus
{
    public static T PromptWithMenu<T>(string question, IReadOnlyList<MenuOption<T>> options)
    {
        while (true)
        {
            Console.WriteLine();
            Console.WriteLine(question);
            for (int index = 0; index < options.Count; index++)
                Console.WriteLine($"{index + 1}- {options[index].Description}");
            Console.WriteLine("What do you want to do?");
            string? input = Console.ReadLine();
            if (int.TryParse(input, out int choice) && choice >= 1 && choice <= options.Count)
                return options[choice -1].Value;
            Console.WriteLine("I did not understand that. Try again");
        }
    }

    public static void WriteLine(string text, ConsoleColor color)
    {
        Console.ForegroundColor = color;
        Console.WriteLine(text);
    }
}

public record MenuItem(string Description, bool IsEnabled, IAction ActionToPerform);

public record MenuOption<T>(string Description, T Value);